// ==UserScript==
// @name         爆サイ全レス表示
// @namespace    http://tampermonkey.net/
// @version      1.0
// @description  爆サイのスレッドの全レスを1ページに自動表示
// @match        https://bakusai.com/thr_res/*
// @grant        none
// ==/UserScript==

(function() {
    'use strict';

    const getNextPage = (page) => {
        const url = new URL(window.location.href);
        url.searchParams.set("p", page);
        return url.toString().replace(/p=\d+/, `p=${page}`);
    };

    const extractPosts = (html) => {
        const parser = new DOMParser();
        const doc = parser.parseFromString(html, "text/html");
        return doc.querySelectorAll('.res_body'); // レス本文のセレクター
    };

    const loadAllPages = async () => {
        let page = 2;
        while (true) {
            const nextURL = getNextPage(page);
            try {
                const res = await fetch(nextURL);
                if (!res.ok) break;
                const text = await res.text();
                const posts = extractPosts(text);
                if (!posts.length) break;

                posts.forEach(post => {
                    document.querySelector('.thread_res_list')?.appendChild(post);
                });

                page++;
            } catch (e) {
                console.error("ページ取得失敗:", e);
                break;
            }
        }
    };

    window.addEventListener('load', () => {
        loadAllPages();
    });
})();
